# Generated by Django 5.2.3 on 2025-07-28 07:10

import django.db.models.deletion
import django.utils.timezone
import shortuuid.django_fields
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('carts', '0003_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.AlterField(
            model_name='cart',
            name='qty',
            field=models.PositiveIntegerField(default=1),
        ),
        migrations.CreateModel(
            name='CartOrder',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('total', models.DecimalField(decimal_places=2, default=0.0, max_digits=12)),
                ('payment_status', models.CharField(choices=[('paid', 'Paid'), ('pending', 'Pending'), ('processing', 'Processing'), ('cancelled', 'Cancelled'), ('initiated', 'Initiated'), ('failed', 'Failed'), ('refunding', 'Refunding'), ('refunded', 'Refunded'), ('unpaid', 'Unpaid'), ('expired', 'Expired')], default='initiated', max_length=100)),
                ('order_status', models.CharField(choices=[('Pending', 'Pending'), ('Fulfilled', 'Fulfilled'), ('Partially Fulfilled', 'Partially Fulfilled'), ('Cancelled', 'Cancelled')], default='Pending', max_length=100)),
                ('full_name', models.CharField(max_length=1000)),
                ('email', models.EmailField(max_length=1000)),
                ('mobile', models.CharField(max_length=1000)),
                ('address', models.CharField(blank=True, max_length=1000, null=True)),
                ('city', models.CharField(blank=True, max_length=1000, null=True)),
                ('state', models.CharField(blank=True, max_length=1000, null=True)),
                ('country', models.CharField(blank=True, max_length=1000, null=True)),
                ('oid', shortuuid.django_fields.ShortUUIDField(alphabet='abcdefghijklmnopqrstuvxyz', length=30, max_length=40, prefix='')),
                ('date', models.DateTimeField(default=django.utils.timezone.now)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='orders', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name_plural': 'Cart Orders',
                'ordering': ['-date'],
            },
        ),
        migrations.AlterField(
            model_name='cartorderitem',
            name='order',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='orderitem', to='carts.cartorder'),
        ),
        migrations.AlterField(
            model_name='deliverycouriers',
            name='cart_order',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='carts.cartorder'),
        ),
    ]
